%Script coefficienti schema differenze finite tramite polynomial fitting
%Equazione flessione piastra Kirchhoff monostrato isotropa
%Scritto da Pavan Andrea - 26/02/2022
clear;
clc;

%% schema centrato IV ordine
A = [1 -2 4 -8 16;
    1 -1 1 -1 1;
    1 0 0 0 0;
    1 1 1 1 1;
    1 2 4 8 16];
Y = inv(A);
d4w_dx4 = 24*Y(5,:);
d2w_dx2 = 2*Y(3,:)+6*Y(4,:)+12*Y(5,:);
fprintf('Coefficienti schema centrato:\n')
fprintf(['> d4w/dx4: ' num2str(d4w_dx4) '\n']);
fprintf(['> d2w/dx2: ' num2str(d2w_dx2) '\n\n']);


%% schema forward IV ordine
A = [1 -1 1 -1 1;
    0 0 2 -6 12;
    1 0 0 0 0;
    1 1 1 1 1;
    1 2 4 8 16];
Y = inv(A);
d4w_dx4 = 24*Y(5,:);
d2w_dx2 = 2*Y(3,:)+6*Y(4,:)+12*Y(5,:);
fprintf('Coefficienti schema forward (per bordo sinistro @x2):\n')
fprintf(['> d4w/dx4: ' num2str(d4w_dx4) '\n']);
fprintf(['> d2w/dx2: ' num2str(d2w_dx2) '\n\n']);


%% schema backward IV ordine
A = [1 1 1 1 1;
    0 0 2 6 12;
    1 0 0 0 0;
    1 -1 1 -1 1;
    1 -2 4 -8 16];
Y = inv(A);
d4w_dx4 = 24*Y(5,:);
d2w_dx2 = 2*Y(3,:)+6*Y(4,:)+12*Y(5,:);
fprintf('Coefficienti schema backward (per bordo bestro @xN-1):\n')
fprintf(['> d4w/dx4: ' num2str(d4w_dx4) '\n']);
fprintf(['> d2w/dx2: ' num2str(d2w_dx2) '\n\n']);

